﻿Public Class CanvasClone
    Inherits Panel
    Public Shared ReadOnly LeftProperty As DependencyProperty =
        DependencyProperty.RegisterAttached("Left",
                                            GetType(Double),
                                            GetType(CanvasClone),
                                            New PropertyMetadata(0.0, AddressOf OnLeftOrTopPropertyChanged))


    Public Shared ReadOnly TopProperty As DependencyProperty =
        DependencyProperty.RegisterAttached("Top",
                                            GetType(Double),
                                            GetType(CanvasClone),
                                            New PropertyMetadata(0.0, AddressOf OnLeftOrTopPropertyChanged))


    Public Shared Sub SetLeft(ByVal obj As DependencyObject, ByVal value As Double)
        obj.SetValue(LeftProperty, value)
    End Sub


    Public Shared Function GetLeft(ByVal obj As DependencyObject) As Double
        Return CDbl(obj.GetValue(LeftProperty))
    End Function


    Public Shared Sub SetTop(ByVal obj As DependencyObject, ByVal value As Double)
        obj.SetValue(TopProperty, value)
    End Sub


    Public Shared Function GetTop(ByVal obj As DependencyObject) As Double
        Return CDbl(obj.GetValue(TopProperty))
    End Function


    Private Shared Sub OnLeftOrTopPropertyChanged(ByVal obj As DependencyObject, ByVal args As DependencyPropertyChangedEventArgs)
        Dim parent = TryCast(VisualTreeHelper.GetParent(obj), CanvasClone)

        If parent IsNot Nothing Then
            parent.InvalidateArrange()
        End If
    End Sub


    Protected Overrides Function MeasureOverride(ByVal availableSize As Size) As Size
        For Each child In Children
            child.Measure(New Size(Double.PositiveInfinity,
                                   Double.PositiveInfinity))
        Next child
        Return Size.Empty
    End Function


    Protected Overrides Function ArrangeOverride(ByVal finalSize As Size) As Size
        For Each child As UIElement In Children
            child.Arrange(New Rect(
                          New Point(GetLeft(child), GetTop(child)), child.DesiredSize))
        Next child

        Return MyBase.ArrangeOverride(finalSize)
    End Function
End Class
